C      *****************************************************************
C      * SUB FGuess                                                    *
C      * This subroutine initializes the component concentrations.     *
C      *                                                               *
C      * Variables:                                                    *
C      * I         -Local - Index holder.  Unitless.                   *
C      * KT        -Input - A matrix, of size NComp by NLayer, of the  *
C      *                    known total amount for each component, for *
C      *                    each layer.  The total includes the amount *
C      *                    of the component as a free component and as*
C      *                    part of all dependent species.  Units are  *
C      *                    mol.                                       *
C      *                    (Common block VModel, file VModel.f)       *
C      * LNum      -Input - The current layer number.  Unitless.       *
C      * SpConc    -Output- A matrix, of size NSpecies by NLayers, of  *
C      *                    species concentrations, one set for each   *
C      *                    layer. Units are mol/L.                    *
C      *                    (Common block VModel, file VModel.f)       *
C      *****************************************************************
       SUBROUTINE FGUESS(LNUM)
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
							INTEGER I, LNUM
							REAL*8 CTOM

c      WRITE(6,*) 'USING EXPLICIT FIRST GUESS ROUTINE FOR ',
c     > 'LOBLOLLY DATA'
c       SPCONC(1,1) = 10.7X-3
c       SPCONC(2,1) = 0.358X-3
c       SPCONC(3,1) = 1.34X-3
c       SPCONC(4,1) = 20.0X-3
c       SPCONC(5,1) = 0.00306X-3
c       SPCONC(6,1) = (1.0/2.95) * 0.001
c       SPCONC(7,1) = 0.0118X-3
c       SPCONC(8,1) = 0.0953X-3
c       SPCONC(9,1) = 0.000477X-3
c       SPCONC(10,1) = 0.176X-3
c       SPCONC(11,1) = 0.00603X-3
c       SPCONC(12,1) = 17.3X-3
c       GOTO 9999


							WRITE(6,*) 'USING FIRST GUESS ROUTINE LAYER ', LNUM
							DO 100 I=1,NCOMP
C	      SPCONC(I, LNUM) = KT(I,LNUM)/CTOM(I,LNUM)
       IF (KT(I,LNUM) .LE. 0.0) THEN
          SPCONC(I, LNUM) = 0.01
       ELSE
	         SPCONC(I, LNUM) = KT(I,LNUM)
       ENDIF
  100  CONTINUE

 9999  CONTINUE
       RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
